package org.msh.tb.bd.tbforms.dhis2.tb10;

import org.msh.tb.bd.tbforms.dhis2.DHIS2ExportAsyncTask;
import org.msh.tb.bd.tbforms.dhis2.data.AuthResponse;
import org.msh.tb.bd.tbforms.dhis2.data.DataValuePayload;
import org.msh.tb.bd.tbforms.dhis2.data.DataValueResponse;
import org.msh.tb.bd.tbforms.dhis2.tb10.blockbuilders.*;
import org.msh.tb.entities.Tbunit;
import org.msh.utils.date.DateUtils;

/**
 * Created by Mauricio on 06/02/2017.
 * Async task used by @{@link DHIS2ExportTB10Home} to export TB 10 form when the user commands it
 */
public class DHIS2ExportTB10AsyncTask extends DHIS2ExportAsyncTask {

    public static final String DHIS2_DATA_SET_ID = "MARm4SH7K0w";

    @Override
    protected void execute() {
        try {
            // login into DHIS2
            AuthResponse credentials = dHIS2AuthenticationService.auth();
            this.setProgress(8);

            // Instantiate block builders
            TBForm10Block1Builder block1 = new TBForm10Block1Builder();
            TBForm10Block2Builder block2 = new TBForm10Block2Builder();
            TBForm10Block3Builder block3 = new TBForm10Block3Builder();
            TBForm10Block4Builder block4 = new TBForm10Block4Builder();
            TBForm10Block5ABuilder block5A = new TBForm10Block5ABuilder();
            TBForm10Block5BBuilder block5B = new TBForm10Block5BBuilder();
            TBForm10Block6ABuilder block6A = new TBForm10Block6ABuilder();
            TBForm10Block6BBuilder block6B = new TBForm10Block6BBuilder();
            TBForm10Block6CBuilder block6C = new TBForm10Block6CBuilder();

            for (int i = 0; i < tbunits.size(); i++) {
                Tbunit tbunit = tbunits.get(i);

                // instantiate and start to prepare payload
                DataValuePayload payload = new DataValuePayload();
                payload.setDataSet(getFormId());
                payload.setCompleteData(DateUtils.getDate());
                payload.setOrgUnit(tbunit.getDhis2Id());
                payload.setPeriod(selectedQuarter.getDHIS2QuarterCode());

                // get information about blocks in DB and mount it in payload
                block1.buildBlock(tbunit, selectedQuarter, payload);
                block2.buildBlock(tbunit, selectedQuarter, payload);
                block3.buildBlock(tbunit, selectedQuarter, payload);
                block4.buildBlock(tbunit, selectedQuarter, payload);
                block5A.buildBlock(tbunit, selectedQuarter, payload);
                block5B.buildBlock(tbunit, selectedQuarter, payload);
                block6A.buildBlock(tbunit, selectedQuarter, payload);
                block6B.buildBlock(tbunit, selectedQuarter, payload);
                block6C.buildBlock(tbunit, selectedQuarter, payload);

                // only sends request if dataValues are found.
                if (payload.getDataValues() != null) {

                    // send unit TB 10 Form information
                    DataValueResponse response = dHIS2DataExportService.sendData(credentials, payload);

                    saveTransactionLog(response, tbunit, selectedQuarter);
                }

                // update progress
                double p = 92.0/tbunits.size();
                p = (p*(i+1))+8.0;
                this.setProgress(new Double(p).intValue());
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getFormId() {
        return DHIS2_DATA_SET_ID;
    }

    @Override
    protected String getEventName() {
        return "DHIS2_INTEGRATION_TB10";
    }

    @Override
    public boolean isLogged() {
        return true;
    }
}
